/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.MicrocodeLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfPrepareResponse;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestHandler;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.CompleteMsg;
import com.ibm.hwmca.fw.rbf.impl.CompleteReply;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.OfferMsg;
import com.ibm.hwmca.fw.rbf.impl.OfferReply;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.persist.PersistableRequestBody;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Constructor;

class HandlerThread
extends Thread {
    private static final String TRACE_MASKT = "XRBFHDTT";
    private static final String TRACE_MASKF = "XRBFHDTF";
    private static final String TRACE_MASKD = "XRBFHDTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-HndlThrd");
    private RbfRequest request;
    private RbfRequestId requestId;
    private boolean handlerClassUnavailable = false;
    private Class handlerClass;
    private String handlerClassName;
    private RbfRequestHandler handler = null;
    private RbfHandleResponse handleResponse = null;
    private RbfErrorDetail appErrorDetail = null;
    private RbfErrorDetail internalErrorDetail = null;
    private boolean terminating = false;
    private Object terminateLock = new Object();
    private static final int OFFER_MSG_TIMEOUT = 360000;
    private static final int COMPLETE_MSG_TIMEOUT = 180000;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$RbfRequest;

    HandlerThread(RbfRequest request) {
        super("RBF Handler Thread - " + request.getIdentifier());
        this.request = request;
        this.requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "<> HandlerThread() " + this.requestId);
    }

    RbfRequest getRequest() {
        return this.request;
    }

    public void run() {
        try {
            Trace.trace(TRACE_MASKT, "-> Handler thread running " + this.requestId);
            if (this.prepare() && !this.terminating) {
                this.handle();
            }
            this.terminate();
            Trace.trace(TRACE_MASKT, "<- Handler thread ending " + this.requestId);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            this.getThreadGroup().uncaughtException(this, throwable);
            try {
                RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                rhMgr.finishedHandling(this.request);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepare() {
        Object desc;
        boolean prepared = false;
        Object object = this.terminateLock;
        synchronized (object) {
            if (!this.terminating) {
                try {
                    this.handler = this.createRequestHandler();
                    if (this.handler == null) {
                        this.handlerClassUnavailable = true;
                    }
                }
                catch (Exception e) {
                    desc = e.getClass().getName() + " creating a " + this.handlerClass.getName() + " instance " + this.requestId + ":\n " + RbfUtils.getStackTrace(e);
                    this.appErrorDetail = new RbfErrorDetail(1058, (String)desc);
                }
            }
        }
        RbfPrepareResponse prepareResponse = null;
        if (this.handler != null) {
            try {
                prepareResponse = this.prepareForRequest();
                if (prepareResponse == null) {
                    String desc2 = "Invalid response (null) returned by " + this.handlerClassName + ".prepareToHandle() " + this.requestId;
                    Trace.trace(TRACE_MASKF, desc2);
                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                    fl.add(desc2);
                    fl.add(RbfUtils.getLoggingInfo(this.request));
                    fl.log();
                    this.appErrorDetail = new RbfErrorDetail(1060, desc2);
                }
            }
            catch (Exception e) {
                desc = "Uncaught exception:\n " + RbfUtils.getStackTrace(e);
                this.appErrorDetail = new RbfErrorDetail(1059, (String)desc);
            }
        }
        RequestTrackingData trackingData = this.request.getTrackingData();
        desc = trackingData;
        synchronized (desc) {
            if (trackingData.state != 4) {
                String desc3 = "Request state " + trackingData.state + " no longer requires handling";
                Trace.trace(TRACE_MASKF, desc3);
                return false;
            }
            if (this.handler == null || this.appErrorDetail != null || this.internalErrorDetail != null) {
                trackingData.state = 6;
                return false;
            }
        }
        OfferMsg offerMsg = new OfferMsg(this.requestId, this.getOfferMsgStatus(prepareResponse));
        MachineId origin = this.request.getOriginMachine();
        OfferReply offerReply = this.sendOfferMsg(offerMsg, origin);
        RequestTrackingData requestTrackingData = trackingData;
        synchronized (requestTrackingData) {
            if (trackingData.state == 4) {
                if (offerReply != null) {
                    int offerReplyStatus = offerReply.getStatus();
                    if (!offerReply.isValidStatus(offerReplyStatus)) {
                        trackingData.state = 6;
                        String desc4 = "Internal error: Invalid offer reply status (" + offerReplyStatus + ") received from " + RbfUtils.getMachineInfo(origin) + " " + this.requestId;
                        Trace.trace(TRACE_MASKF, desc4);
                        FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                        fl.add(desc4);
                        fl.add(RbfUtils.getLoggingInfo(this.request));
                        fl.log();
                        this.internalErrorDetail = new RbfErrorDetail(1060, desc4);
                    } else if (offerReplyStatus == 0) {
                        try {
                            this.request.setBody(this.decodeRequestBody(offerReply.getRequestBodyEncoding()));
                            trackingData.state = 8;
                            trackingData.handler = FcsServer.getFcsServer().getLocalMachineId();
                            prepared = true;
                        }
                        catch (PersistenceException pe) {
                            trackingData.state = 6;
                            String desc5 = pe.getClass().getName() + " decoding request body " + "from " + RbfUtils.getMachineInfo(origin) + " " + this.requestId + ":\n" + RbfUtils.getStackTrace(pe);
                            this.appErrorDetail = new RbfErrorDetail(1057, desc5);
                        }
                    } else if (offerReplyStatus == 6) {
                        trackingData.state = 12;
                        trackingData.canceled = true;
                    } else {
                        trackingData.state = 6;
                    }
                } else {
                    trackingData.state = 6;
                }
            } else {
                String desc6 = "Request state " + trackingData.state + " no longer requires handling";
                Trace.trace(TRACE_MASKF, desc6);
            }
        }
        return prepared;
    }

    private RbfRequestHandler createRequestHandler() throws Exception {
        RbfRequestHandler handler = null;
        RbfRequestType reqType = this.request.getType();
        this.handlerClass = HandlerManager.getHandlerManager().getLocalHandlerClass(reqType);
        if (this.handlerClass != null) {
            this.handlerClassName = this.handlerClass.getName();
            try {
                Constructor constructor = this.handlerClass.getConstructor(class$com$ibm$hwmca$fw$rbf$RbfRequest == null ? (class$com$ibm$hwmca$fw$rbf$RbfRequest = HandlerThread.class$("com.ibm.hwmca.fw.rbf.RbfRequest")) : class$com$ibm$hwmca$fw$rbf$RbfRequest);
                handler = (RbfRequestHandler)constructor.newInstance(this.request);
            }
            catch (Exception e) {
                String desc = e.getClass().getName() + " creating a " + this.handlerClassName + " instance " + this.requestId + ":\n " + RbfUtils.getStackTrace(e);
                Trace.trace(TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1058);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(this.request));
                fl.log();
                throw e;
            }
        } else {
            Trace.trace(TRACE_MASKF, "No locally registered handler class for " + reqType);
        }
        return handler;
    }

    private RbfPrepareResponse prepareForRequest() throws Exception {
        Trace.trace(TRACE_MASKF, "-> " + this.handlerClassName + ".prepareToHandle() " + this.requestId);
        RbfPrepareResponse prepareResponse = null;
        try {
            prepareResponse = this.handler.prepareToHandle();
        }
        catch (Exception e) {
            String desc = "Uncaught exception from " + this.handlerClassName + ".prepareToHandle() " + this.requestId + ":\n" + RbfUtils.getStackTrace(e);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1059);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(this.request));
            fl.log();
            throw e;
        }
        Trace.trace(TRACE_MASKF, "<- " + this.handlerClassName + ".prepareToHandle() " + this.requestId);
        Trace.trace(TRACE_MASKF, "prepareToHandle()=" + prepareResponse);
        return prepareResponse;
    }

    private int getOfferMsgStatus(RbfPrepareResponse response) {
        if (response == null) {
            return 4;
        }
        switch (response.getStatus()) {
            case 4: {
                return 4;
            }
            case 0: {
                return 0;
            }
        }
        return 4;
    }

    private OfferReply sendOfferMsg(OfferMsg msg, MachineId target) {
        try {
            CommManager commMgr = CommManager.getCommManager();
            RbfReply reply = commMgr.send(msg, target, 360000);
            if (reply instanceof OfferReply) {
                return (OfferReply)reply;
            }
            String desc = "Internal error: Invalid offer reply (" + reply.getClass().getName() + ") received from " + RbfUtils.getMachineInfo(target) + " " + this.requestId;
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(this.request));
            fl.log();
            return null;
        }
        catch (RbfException rbfe) {
            return null;
        }
    }

    private Object decodeRequestBody(byte[] bodyEncoding) throws PersistenceException {
        if (bodyEncoding == null) {
            return null;
        }
        try {
            PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
            return ((PersistableRequestBody)PersistenceManager.decode(bodyEncoding)).getBody();
        }
        catch (PersistenceException pe) {
            String desc = pe.getClass().getName() + " decoding request " + "body " + this.requestId + ":\n" + RbfUtils.getStackTrace(pe);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1057);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(this.request));
            fl.log();
            throw pe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle() {
        RequestTrackingData trackingData;
        try {
            this.handleResponse = this.handleRequest();
            if (this.handleResponse == null) {
                String desc = "Invalid response (null) returned by " + this.handlerClassName + ".handle() " + this.requestId;
                Trace.trace(TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(this.request));
                fl.log();
                this.appErrorDetail = new RbfErrorDetail(1060, desc);
            }
        }
        catch (Exception e) {
            String desc = "Uncaught exception:\n" + RbfUtils.getStackTrace(e);
            this.appErrorDetail = new RbfErrorDetail(1059, desc);
        }
        RequestTrackingData requestTrackingData = trackingData = this.request.getTrackingData();
        synchronized (requestTrackingData) {
            if (trackingData.state != 8) {
                String desc = "Request state " + trackingData.state + " no longer requires handling";
                Trace.trace(TRACE_MASKF, desc);
            } else if (this.appErrorDetail != null || this.internalErrorDetail != null) {
                trackingData.state = 6;
            }
        }
    }

    private RbfHandleResponse handleRequest() throws Exception {
        Trace.trace(TRACE_MASKF, "-> " + this.handlerClassName + ".handle() " + this.requestId);
        RbfHandleResponse handleResponse = null;
        try {
            handleResponse = this.handler.handle();
        }
        catch (Exception e) {
            String desc = "Uncaught exception from " + this.handlerClassName + ".handle() " + this.requestId + ":\n" + RbfUtils.getStackTrace(e);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1059);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(this.request));
            fl.log();
            throw e;
        }
        Trace.trace(TRACE_MASKF, "<- " + this.handlerClassName + ".handle() " + this.requestId);
        Trace.trace(TRACE_MASKF, "handle()=" + handleResponse);
        return handleResponse;
    }

    void terminate() {
        this.terminate(false);
    }

    void terminateAsync() {
        this.terminate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(boolean async) {
        Trace.trace(TRACE_MASKT, "-> terminate() " + this.requestId);
        boolean doit = false;
        Object object = this.terminateLock;
        synchronized (object) {
            if (!this.terminating) {
                this.terminating = true;
                doit = true;
            } else {
                Trace.trace(TRACE_MASKF, "Already terminating or terminated");
            }
        }
        if (doit) {
            if (async) {
                Thread terminateThread = new Thread(new Runnable(){

                    public void run() {
                        Trace.trace(HandlerThread.TRACE_MASKT, "-> Async termination " + HandlerThread.this.requestId);
                        HandlerThread.this.doTermination();
                        Trace.trace(HandlerThread.TRACE_MASKT, "<- Async termination " + HandlerThread.this.requestId);
                    }
                }, "RBF Terminate HandlerThread Async - " + this.requestId);
                terminateThread.start();
            } else {
                this.doTermination();
            }
        }
        Trace.trace(TRACE_MASKT, "<- terminate() " + this.requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTermination() {
        Object fl;
        if (this.handler != null) {
            try {
                Trace.trace(TRACE_MASKF, "-> " + this.handlerClassName + ".terminate() " + this.requestId);
                this.handler.terminate();
                Trace.trace(TRACE_MASKF, "<- " + this.handlerClassName + ".terminate() " + this.requestId);
            }
            catch (Exception e) {
                String desc = "Uncaught exception from " + this.handlerClassName + ".terminate() " + this.requestId + ":\n" + RbfUtils.getStackTrace(e);
                Trace.trace(TRACE_MASKF, desc);
                fl = new FrameworkLog(classLogInfo, 1059);
                ((Log)fl).add(desc);
                ((Log)fl).add(RbfUtils.getLoggingInfo(this.request));
                ((MicrocodeLog)fl).log();
            }
        }
        CompleteMsg completeMsg = null;
        RequestTrackingData trackingData = this.request.getTrackingData();
        fl = trackingData;
        synchronized (fl) {
            completeMsg = this.determineCompleteMsg(trackingData);
            trackingData.state = 20;
        }
        if (completeMsg != null) {
            CompleteReply reply = this.sendCompleteMsg(completeMsg, trackingData.origin);
        }
        try {
            RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
            rhMgr.finishedHandling(this.request);
        }
        catch (PersistenceNotInitializedException persistenceNotInitializedException) {
            // empty catch block
        }
    }

    private CompleteMsg determineCompleteMsg(RequestTrackingData trackingData) {
        CompleteMsg msg = null;
        if (trackingData.state == 4) {
            msg = new CompleteMsg(this.request, 4, null);
        } else if (trackingData.state == 8) {
            try {
                msg = new CompleteMsg(this.request, this.handleResponse);
            }
            catch (PersistenceException pe) {
                String desc = pe.getClass().getName() + " encoding " + this.handleResponse.getClass().getName() + ":\n" + RbfUtils.getStackTrace(pe);
                this.appErrorDetail = new RbfErrorDetail(1056, desc);
                msg = new CompleteMsg(this.request, 12, this.appErrorDetail);
            }
        } else if (trackingData.state == 6) {
            msg = this.appErrorDetail != null ? new CompleteMsg(this.request, 12, this.appErrorDetail) : (this.internalErrorDetail != null ? new CompleteMsg(this.request, 8, this.internalErrorDetail) : (this.handler == null && this.handlerClassUnavailable ? new CompleteMsg(this.request, 6, null) : new CompleteMsg(this.request, 4, null)));
        } else if (trackingData.state == 12) {
            // empty if block
        }
        return msg;
    }

    private CompleteReply sendCompleteMsg(CompleteMsg msg, MachineId target) {
        try {
            CommManager commMgr = CommManager.getCommManager();
            RbfReply reply = commMgr.send(msg, target, 180000);
            if (reply instanceof CompleteReply) {
                return (CompleteReply)reply;
            }
            String desc = "Internal error: Invalid complete reply (" + reply.getClass().getName() + ") received from " + RbfUtils.getMachineInfo(target) + " " + this.requestId;
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(this.request));
            fl.log();
            return null;
        }
        catch (RbfException rbfe) {
            if (msg.getStatus() == 0 && this.handleResponse != null) {
                try {
                    RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                    rhMgr.storeHandleResponse(this.handleResponse);
                }
                catch (PersistenceNotInitializedException pnie) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

